/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class Search
extends JPanel
implements MouseListener {
    Aladin aladin;
    SearchText text;
    JLabel label;
    JButton left;
    JButton right;
    JButton out;
    JButton reduce;
    protected JPanel panelSearch;
    static String MFSEARCHIN = null;
    static String MFSEARCHOUT;
    static String MFSEARCHNO;
    static String YOURSEARCH;
    private boolean flagHideSearch = false;
    static String SELECT;
    static String UNSELECT;
    static String APPEND;
    static String SHOW;
    private Insets INSETS = new Insets(1, 0, 3, 0);
    boolean oEnable = true;
    static final int DEFAULT = 0;
    static final int IN = 1;
    static final int OUT = 2;
    static final int NO = 3;
    static final int DISABLE = 4;

    protected Search(Aladin aladin, boolean withReduceButton) {
        JButton b;
        this.aladin = aladin;
        this.setBackground(aladin.getBackground());
        if (MFSEARCHIN == null) {
            MFSEARCHIN = Aladin.chaine.getString("MFSEARCHIN");
            MFSEARCHOUT = Aladin.chaine.getString("VWNIF");
            MFSEARCHNO = Aladin.chaine.getString("MFSEARCHNO");
            YOURSEARCH = Aladin.chaine.getString("MFSEARCHFOCUS");
        }
        this.left = b = new JButton(new ImageIcon(aladin.getImagette("Left.gif")));
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setToolTipText(Aladin.chaine.getString("MFSEARCHLEFT"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Search.this.down();
            }
        });
        this.right = b = new JButton(new ImageIcon(aladin.getImagette("Right.gif")));
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setToolTipText(Aladin.chaine.getString("MFSEARCHRIGHT"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Search.this.up();
            }
        });
        this.text = new SearchText();
        this.text.setFont(Aladin.BOLD);
        this.text.setToolTipText(Aladin.chaine.getString("MFSEARCHEX"));
        this.text.addMouseListener(this);
        this.setLayout(new BorderLayout(0, 0));
        JPanel searchPanel = new JPanel(new BorderLayout(0, 0));
        searchPanel.setBackground(aladin.getBackground());
        JPanel pText = new JPanel(new BorderLayout());
        pText.setBackground(aladin.getBackground());
        pText.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        pText.add((Component)this.text, "Center");
        searchPanel.add((Component)pText, "Center");
        this.panelSearch = new JPanel(new BorderLayout(0, 0));
        this.panelSearch.setBackground(aladin.getBackground());
        JPanel searchControlPanel = new JPanel(new BorderLayout(0, 0));
        searchControlPanel.setBackground(aladin.getBackground());
        searchControlPanel.add((Component)this.left, "Center");
        searchControlPanel.add((Component)this.right, "East");
        JPanel genericSearchPanel = new JPanel(new BorderLayout(0, 0));
        genericSearchPanel.setBackground(aladin.getBackground());
        genericSearchPanel.add((Component)searchPanel, "West");
        genericSearchPanel.add((Component)searchControlPanel, "Center");
        this.panelSearch.add((Component)genericSearchPanel, "West");
        this.add((Component)this.panelSearch, "Center");
        this.setEnabled(false);
        this.addMouseListener(this);
    }

    protected boolean hideSearch(boolean flag) {
        if (flag == this.flagHideSearch) {
            return false;
        }
        this.flagHideSearch = flag;
        if (this.flagHideSearch) {
            this.remove(this.panelSearch);
        } else {
            this.add((Component)this.panelSearch, "Center");
        }
        this.validate();
        return true;
    }

    private void down() {
        if (this.aladin.mesure.nbSrc == 0) {
            this.text.execute(10, null, 0);
        } else {
            this.text.execute(40, null, 0);
        }
    }

    private void up() {
        if (this.aladin.mesure.nbSrc == 0) {
            this.text.execute(10, null, 0);
        } else {
            this.text.execute(38, null, 0);
        }
    }

    private void go() {
        this.text.execute(10, null, 0);
    }

    private void split() {
        this.aladin.mesure.split();
    }

    private int getDefaultMode() {
        return 0;
    }

    protected void focus() {
        this.text.setText(YOURSEARCH);
        new Thread(){
            Color def;
            Color deff;
            {
                this.def = Search.this.text.getBackground();
                this.deff = Search.this.text.getForeground();
            }

            @Override
            public void run() {
                for (int i = 0; i < 3; ++i) {
                    Search.this.text.setBackground(Color.green);
                    Search.this.text.setForeground(Aladin.COLOR_CONTROL_FOREGROUND);
                    Util.pause(200);
                    Search.this.text.setBackground(this.def);
                    Search.this.text.setForeground(this.deff);
                    Util.pause(200);
                }
                Search.this.text.setText("");
                Search.this.text.requestFocusInWindow();
            }
        }.start();
    }

    protected void focusOnLeft() {
        new Thread(){

            @Override
            public void run() {
                Color cp = Search.this.left.getParent().getBackground();
                boolean mode = false;
                for (int i = 0; i < 8; ++i) {
                    Search.this.left.getParent().setBackground(mode ? cp : Color.green);
                    mode = !mode;
                    Util.pause(500);
                }
                Search.this.left.getParent().setBackground(cp);
            }
        }.start();
    }

    @Override
    public Insets getInsets() {
        return this.INSETS;
    }

    void setText(String s) {
        this.text.setText(s);
    }

    public String getText() {
        return this.text.getText();
    }

    @Override
    public void setEnabled(boolean flag) {
        boolean x = flag;
        if (this.aladin.mesure != null) {
            x = this.aladin.mesure.nbSrc > 0;
        }
        this.right.setEnabled(x);
        this.left.setEnabled(x);
        if (flag == this.oEnable) {
            return;
        }
        this.oEnable = flag;
        this.text.setEnabled(flag);
        this.setColor(flag ? 0 : 4);
        if (this.aladin.mesure != null) {
            flag = this.aladin.mesure.nbSrc > 0;
        }
        this.right.setEnabled(flag);
        this.left.setEnabled(flag);
    }

    protected void setColor(int mode) {
        switch (mode) {
            case 1: {
                this.text.setBackground(Aladin.COLOR_BUTTON_BACKGROUND);
                this.text.setForeground(Aladin.COLOR_BUTTON_FOREGROUND);
                break;
            }
            case 3: {
                this.text.setBackground(Color.red);
                this.text.setForeground(Color.white);
                break;
            }
            case 2: {
                this.text.setBackground(Color.orange);
                this.text.setForeground(Color.magenta);
                break;
            }
            case 4: {
                this.text.setBackground(this.getBackground());
                this.text.setForeground(this.getBackground());
                break;
            }
            default: {
                this.text.setBackground(Aladin.COLOR_BUTTON_BACKGROUND);
                this.text.setForeground(Aladin.COLOR_BUTTON_FOREGROUND);
            }
        }
    }

    protected String Help() {
        return Aladin.chaine.getString("Search.HELP");
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.aladin.inHelp) {
            this.aladin.help.setText(this.Help());
            return;
        }
    }

    void execute(String s) {
        if (s == null) {
            s = this.text.getText();
        }
        int mode = s.equals("+") ? 1 : (s.equals("-") ? -1 : 0);
        switch (mode) {
            case -1: {
                this.text.execute(38, s, 0);
                break;
            }
            case 1: {
                this.text.execute(40, s, 0);
                break;
            }
            case 0: {
                this.text.execute(10, s, 0);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.oEnable) {
            return;
        }
        this.setColor(0);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    void setColorAndStatus(int rep) {
        this.setColor(rep == 0 ? 3 : (rep == 1 ? 1 : 2));
        if (rep == 0) {
            this.aladin.mesure.showStatus(MFSEARCHNO);
        } else if (rep == -1) {
            this.aladin.mesure.showStatus(MFSEARCHOUT);
        } else {
            this.aladin.mesure.showStatus(MFSEARCHIN);
        }
    }

    class SearchText
    extends JTextField
    implements KeyListener,
    MouseWheelListener {
        private Dimension DIM = new Dimension(100, 10);
        protected String previousSearch = "";
        protected int oNbSrc = 0;
        String info = null;

        SearchText() {
            this.addKeyListener(this);
            this.addMouseWheelListener(this);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.DIM;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int mode = e.getWheelRotation();
            Search.this.setColorAndStatus(Search.this.aladin.mesure.searchString(this.getText(), mode));
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.execute(e.getKeyCode(), this.getText(), Search.this.getDefaultMode());
        }

        public boolean searchChanged() {
            try {
                return Search.this.aladin.mesure.nbSrc != this.oNbSrc || !this.previousSearch.equals(this.getText());
            }
            catch (Exception e) {
                return false;
            }
        }

        public void execute(int keyCode, String s, int flagAdd) {
            int mode;
            if (s == null) {
                s = this.getText();
            }
            if (keyCode == 10 && flagAdd != 2) {
                boolean rep;
                this.previousSearch = s;
                if (s.length() > 0 && (s.charAt(0) == '-' || s.charAt(0) == '+')) {
                    flagAdd = s.charAt(0) == '-' ? -1 : 1;
                    s = s.substring(1);
                    Search.this.text.setText(s);
                }
                Search.this.setColor((rep = Search.this.aladin.mesure.selectByString(s, flagAdd)) ? 0 : 3);
                Search.this.right.setEnabled(rep);
                Search.this.left.setEnabled(rep);
                Search.this.text.selectAll();
                this.oNbSrc = Search.this.aladin.mesure.nbSrc;
                return;
            }
            int n = keyCode == 38 ? -1 : (mode = keyCode == 40 || keyCode == 10 ? 1 : 0);
            if (mode != 0) {
                if (keyCode == 10) {
                    Search.this.text.setText(s);
                }
                Search.this.setColorAndStatus(Search.this.aladin.mesure.searchString(s, mode));
                Search.this.text.selectAll();
            }
        }

        void setInfo(String s) {
            this.info = s;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isEnabled() && this.getText().length() == 0 && !this.isFocusOwner()) {
                if (this.info == null) {
                    Aladin cfr_ignored_0 = Search.this.aladin;
                    this.info = Aladin.chaine.getString("MFSEARCHL");
                }
                g.setColor(Aladin.COLOR_BUTTON_FOREGROUND);
                g.setFont(this.getFont().deriveFont(2));
                g.drawString(this.info, 5, this.getHeight() - 5);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Search.this.setColor(0);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

